const base64toBlob = (base64) => {
    const buffer = new Uint8Array(base64.length);
    for (let i = 0; i < base64.length; i++) {
        buffer[i] = base64.charCodeAt(i);
    }
    return new Blob([buffer.buffer], { type: "application/octet-stream" });
}

const sendGET = (url, params) => {
    if (params) {
        let queryParam = [];
        for (let key of Object.keys(params)) {
            queryParam.push(key + '=' + params[key]);
        }
        url = url + '?' + queryParam.join('&');
    }
    const controller = new AbortController();
    const request = { method: 'GET', mode: 'no-cors', signal: controller.signal };
    setTimeout(() => { controller.abort(); }, 10000);  // set timeout 5s
    return fetch(`http://192.168.4.1/${url}`, request);
}

const sendFinish = () => {
    return sendGET('finish');
}

const sendUpdate = (blob) => {
    const fd = new FormData();
    fd.append('file', blob);
    const request = { method: 'POST', mode: 'no-cors', body: fd };
    return fetch('http://192.168.4.1/update', request); // Can't read response for 'no-cors'.
}

const update = async () => {
    try {
        await sendUpdate(base64toBlob(testmode.bin));
        document.body.innerHTML = '更新が完了しました。ウインドウを閉じてアプリに戻ってご使用ください。<br/>' +
            'The update is finished. Please close the window and return to the app.<br/>'+
            '업데이트가 끝났습니다. 창을 닫고 프로그램을 계속해서 사용해 주세요.';
        window.close();
    } catch (err) {
        document.body.innerHTML = 'エラーが発生しました。アーテックロガーとWiFi接続されているか、ご確認ください。<br/>' +
            'An error has occurred. Please check if you have a WiFi connection with the Artec logger.<br/>'+
            '에러가 발생했습니다. Artec Logger와 WiFi로 접속되어 있는지 확인해 주세요.';
    }
}

document.getElementById("next").onclick = e => {
    document.getElementById("page1").setAttribute("style", "display:none");
    document.getElementById("page2").removeAttribute("style");
    update();
}
