/*
 * Decompiled with CFR 0.152.
 */
package boardmanager;

import boardmanager.PortManager;
import constants.BuildConst;
import constants.BuildConst10x;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Calendar;

public class Main {
    private static final String osName = System.getProperty("os.name");
    private static final String CalibModeFile = "ar.cpp.hex";
    private static final String TestModeFile = "ar.cpp.hex";
    private static final String TestModeFileA = "ar.cpp.hex_ACC";
    private static final String TestModeFileG = "ar.cpp.hex_GYRO";
    private static final String TestModeFileC = "ar.cpp.hex_COLOR";
    private static final String TestModeFileI = "ar.cpp.hex_IRREMOTE";
    private static final String TestModePath = "." + File.separator + "etc" + File.separator;
    private static final int MAXPROGRAMSIZE = 15872;
    private static final int BuildError = 0;
    private static final int BuildSuccess = 1;
    private static final int BuildFlashOverflow = 2;
    static String portNumber = "portNumber.info";
    static int ErrorNumber;

    public static void main(String[] args) throws IOException {
        System.out.println(osName);
        String host = "127.0.0.1";
        ServerSocket servSock = null;
        InetAddress localAddr = InetAddress.getByName(host);
        int port = 49212;
        while (port < 65535) {
            try {
                servSock = new ServerSocket(port, 0, localAddr);
                break;
            }
            catch (IOException iOException) {
                ++port;
            }
        }
        System.out.println(port);
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(new File(portNumber)));
        dos.writeInt(port);
        dos.close();
        byte[] bytes = new byte[256];
        String data = null;
        boolean clientFinish = false;
        do {
            System.out.println("Waiting for a connection... ");
            Socket clntSock = servSock.accept();
            SocketAddress clientAddress = clntSock.getRemoteSocketAddress();
            System.out.println("Connected!\uff1a" + clientAddress);
            data = null;
            InputStream in = clntSock.getInputStream();
            OutputStream out = clntSock.getOutputStream();
            try {
                int i;
                while ((i = in.read(bytes, 0, bytes.length)) != 0) {
                    data = new String(bytes, 0, i, "ASCII");
                    System.out.println("Received: " + data);
                    data = data.replace("\r", "").replace("\n", "");
                    if (data.equals("CALIB")) {
                        Main.transferBoardSide(out, String.valueOf(TestModePath) + "ar.cpp.hex");
                    }
                    if (data.equals("RUN")) {
                        Main.makeAndTransferProgram(out);
                    }
                    if (data.equals("RESET")) {
                        Main.getPortNumber(out);
                    }
                    if (data.equals("TEST")) {
                        Main.transferBoardSide(out, String.valueOf(TestModePath) + "ar.cpp.hex");
                    }
                    if (data.equals("TESTA")) {
                        Main.transferBoardSide(out, String.valueOf(TestModePath) + TestModeFileA);
                    }
                    if (data.equals("TESTG")) {
                        Main.transferBoardSide(out, String.valueOf(TestModePath) + TestModeFileG);
                    }
                    if (data.equals("TESTC")) {
                        Main.transferBoardSide(out, String.valueOf(TestModePath) + TestModeFileC);
                    }
                    if (data.equals("TESTI")) {
                        Main.transferBoardSide(out, String.valueOf(TestModePath) + TestModeFileI);
                    }
                    if (!data.equals("BREAK")) {
                        if (!data.equals("FINISH")) continue;
                        String ack = "ACK\r\n";
                        byte[] msg = ack.getBytes("ASCII");
                        out.write(msg, 0, msg.length);
                        System.out.println("Sent: " + ack);
                        clientFinish = true;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            clntSock.close();
        } while (!clientFinish);
        servSock.close();
    }

    static void makeAndTransferProgram(OutputStream stream) {
        System.out.println(System.getProperty("os.name"));
        System.out.println(File.separator);
        int ret = Main.buildUserProgram();
        if (ret == 1) {
            boolean isTransferred = Main.transferUserProgram(String.valueOf(BuildConst.ArduinoSystemPath) + BuildConst.USER_PROGRAM);
            if (isTransferred) {
                PortManager port = PortManager.getInstance();
                try {
                    String data = String.valueOf(port.getPortName()) + ";\r\n";
                    byte[] msg = data.getBytes("ASCII");
                    stream.write(msg, 0, msg.length);
                    data = String.valueOf(String.valueOf(msg.length)) + ";\r\n";
                    msg = data.getBytes("ASCII");
                    stream.write(msg, 0, msg.length);
                    data = "FINISH\r\n";
                    msg = data.getBytes("ASCII");
                    stream.write(msg, 0, msg.length);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    String data = "ERR;\r\n";
                    byte[] msg = data.getBytes("ASCII");
                    stream.write(msg, 0, msg.length);
                    data = String.valueOf(String.valueOf(ErrorNumber)) + ";\r\n";
                    msg = data.getBytes("ASCII");
                    stream.write(msg, 0, msg.length);
                    data = "FINISH\r\n";
                    msg = data.getBytes("ASCII");
                    stream.write(msg, 0, msg.length);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            Main.sendErrorMessage(stream);
        }
    }

    public static void sendErrorMessage(OutputStream stream) {
        try {
            String data = "ERR;\r\n";
            byte[] msg = data.getBytes("ASCII");
            stream.write(msg, 0, msg.length);
            data = String.valueOf(String.valueOf(ErrorNumber)) + ";\r\n";
            msg = data.getBytes("ASCII");
            stream.write(msg, 0, msg.length);
            data = "FINISH\r\n";
            msg = data.getBytes("ASCII");
            stream.write(msg, 0, msg.length);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int prebuildStuduinoLibrary() {
        try {
            String arg = null;
            String exe = null;
            ErrorNumber = 0;
            exe = String.valueOf(BuildConst.ArduinoSystemPath) + BuildConst.Compiler;
            if (osName.indexOf("Windows") >= 0) {
                exe = String.valueOf(exe) + ".exe";
            } else if (osName.indexOf("Linux") >= 0) {
                exe = "/usr/share/arduino/hardware/tools/avr/bin/avr-g++";
            }
            arg = String.valueOf(BuildConst10x.CompilerOption) + " ";
            int i = 0;
            while (i < BuildConst10x.IncludeFiles.length - 1) {
                arg = String.valueOf(arg) + "-I" + BuildConst.ArduinoSystemPath + BuildConst10x.IncludeFiles[i] + " ";
                ++i;
            }
            arg = String.valueOf(arg) + BuildConst.ArduinoSystemPath + BuildConst.LibStuduinoSource + " ";
            arg = String.valueOf(arg) + "-o " + BuildConst.ArduinoSystemPath + BuildConst.LibStuduinoObject;
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(exe);
            String[] args = arg.split(" ");
            int i2 = 0;
            while (i2 < args.length) {
                commands.add(args[i2]);
                System.out.println("args[" + i2 + "]: " + args[i2]);
                ++i2;
            }
            ProcessBuilder pb = new ProcessBuilder(commands);
            Process p = pb.start();
            int ret = p.waitFor();
            String error = "";
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while ((line = br.readLine()) != null) {
                    error = String.valueOf(error) + line;
                }
                br.close();
            }
            catch (IOException br) {
                // empty catch block
            }
            if (error != "") {
                error = error.replace("\r\r\n", "\n");
                String[] errLogs = error.split("\n");
                int errorFlag = 0;
                String[] stringArray = errLogs;
                int n = errLogs.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (line.contains("was not declared in this scope")) {
                        if (!(errorFlag & true)) {
                            errorFlag |= 1;
                        }
                    } else if (line.contains("error:")) {
                        if ((errorFlag & 2) == 0) {
                            errorFlag |= 2;
                        }
                    } else {
                        line.contains("warning:");
                    }
                    if (errorFlag != 0) {
                        Main.writeCompileLog("CompileError", error);
                        ErrorNumber = 16 + errorFlag;
                        System.out.println(0);
                        return 0;
                    }
                    ++n2;
                }
            }
            System.out.println("compiler: " + ret);
            return 1;
        }
        catch (InterruptedException e) {
            ErrorNumber = 5;
            return 0;
        }
        catch (IOException e) {
            ErrorNumber = 5;
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int buildUserProgram() {
        try {
            String line;
            String arg = null;
            String exe = null;
            ErrorNumber = 0;
            exe = String.valueOf(BuildConst.ArduinoSystemPath) + BuildConst.Compiler;
            if (osName.indexOf("Windows") >= 0) {
                exe = String.valueOf(exe) + ".exe";
            } else if (osName.indexOf("Linux") >= 0) {
                exe = "/usr/share/arduino/hardware/tools/avr/bin/avr-g++";
            }
            System.out.println("exe: " + exe);
            arg = String.valueOf(BuildConst10x.CompilerOption) + " ";
            int i = 0;
            while (i < BuildConst10x.IncludeFiles.length) {
                arg = String.valueOf(arg) + "-I" + BuildConst.ArduinoSystemPath + BuildConst10x.IncludeFiles[i] + " ";
                ++i;
            }
            arg = String.valueOf(arg) + BuildConst.UserCodePath + BuildConst.SourceFile + " ";
            arg = String.valueOf(arg) + "-o " + BuildConst.ArduinoSystemPath + BuildConst.ObjectFile;
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(exe);
            String[] args = arg.split(" ");
            int i2 = 0;
            while (i2 < args.length) {
                commands.add(args[i2]);
                System.out.println("args[" + i2 + "]: " + args[i2]);
                ++i2;
            }
            ProcessBuilder pb = new ProcessBuilder(commands);
            Process p = pb.start();
            int ret = p.waitFor();
            String error = "";
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while ((line = br.readLine()) != null) {
                    error = String.valueOf(error) + line;
                }
                br.close();
            }
            catch (IOException br) {
                // empty catch block
            }
            if (error != "") {
                error = error.replace("\r\r\n", "\n");
                String[] errLogs = error.split("\n");
                int errorFlag = 0;
                String[] stringArray = errLogs;
                int n = errLogs.length;
                int n2 = 0;
                while (n2 < n) {
                    String line2 = stringArray[n2];
                    if (line2.contains("was not declared in this scope")) {
                        if (!(errorFlag & true)) {
                            errorFlag |= 1;
                        }
                    } else if (line2.contains("error:")) {
                        if ((errorFlag & 2) == 0) {
                            errorFlag |= 2;
                        }
                    } else {
                        line2.contains("warning:");
                    }
                    if (errorFlag != 0) {
                        Main.writeCompileLog("CompileError", error);
                        ErrorNumber = 16 + errorFlag;
                        System.out.println(0);
                        return 0;
                    }
                    ++n2;
                }
            }
            System.out.println("compiler: " + ret);
            exe = String.valueOf(BuildConst.ArduinoSystemPath) + BuildConst.Linker;
            if (osName.indexOf("Windows") >= 0) {
                exe = String.valueOf(exe) + ".exe";
            } else if (osName.indexOf("Linux") >= 0) {
                exe = "/usr/share/arduino/hardware/tools/avr/bin/avr-gcc";
            }
            arg = String.valueOf(BuildConst.LinkerOption) + " ";
            arg = String.valueOf(arg) + "-o " + BuildConst.ArduinoSystemPath + BuildConst.ElfFile + " ";
            arg = String.valueOf(arg) + BuildConst.ArduinoSystemPath + BuildConst.ObjectFile + " ";
            int i3 = 0;
            while (i3 < BuildConst10x.LinkFiles.length) {
                arg = String.valueOf(arg) + BuildConst.ArduinoSystemPath + BuildConst10x.LinkFiles[i3] + " ";
                ++i3;
            }
            arg = String.valueOf(arg) + BuildConst.ArduinoSystemPath + BuildConst.ArchiverFile + " ";
            arg = String.valueOf(arg) + "-L" + BuildConst.ArduinoSystemPath + BuildConst.LinkDirectory;
            commands.clear();
            commands.add(exe);
            args = arg.split(" ");
            i3 = 0;
            while (i3 < args.length) {
                commands.add(args[i3]);
                ++i3;
            }
            pb.command(commands);
            p = pb.start();
            ret = p.waitFor();
            error = "";
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while ((line = br.readLine()) != null) {
                    error = String.valueOf(error) + line;
                }
                br.close();
            }
            catch (IOException br) {
                // empty catch block
            }
            if (error != "") {
                Main.writeCompileLog("LinkError", error);
                ErrorNumber = 7;
                return 0;
            }
            System.out.println("linker: " + ret);
            exe = String.valueOf(BuildConst.ArduinoSystemPath) + BuildConst.ObjDump;
            if (osName.indexOf("Windows") >= 0) {
                exe = String.valueOf(exe) + ".exe";
            } else if (osName.indexOf("Linux") >= 0) {
                exe = "/usr/share/arduino/hardware/tools/avr/bin/avr-objdump";
            }
            arg = "-h " + BuildConst.ArduinoSystemPath + BuildConst.ElfFile;
            commands.clear();
            commands.add(exe);
            args = arg.split(" ");
            i = 0;
            while (i < args.length) {
                commands.add(args[i]);
                ++i;
            }
            pb.command(commands);
            p = pb.start();
            ret = p.waitFor();
            try {
                String line3;
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String dataSize = "";
                String textSize = "";
                String bssSize = "";
                System.out.println("objcump");
                block21: while ((line3 = br.readLine()) != null) {
                    String[] token = line3.split(" ");
                    int i4 = 0;
                    while (i4 < token.length) {
                        int j;
                        if (token[i4].equals(".data")) {
                            j = i4 + 1;
                            while (token[j].equals("")) {
                                ++j;
                            }
                            dataSize = token[j];
                            i4 = j;
                        } else if (token[i4].equals(".text")) {
                            j = i4 + 1;
                            while (token[j].equals("")) {
                                ++j;
                            }
                            textSize = token[j];
                            i4 = j;
                        } else if (token[i4].equals(".bss")) {
                            j = i4 + 1;
                            while (token[j].equals("")) {
                                ++j;
                            }
                            bssSize = token[j];
                            continue block21;
                        }
                        ++i4;
                    }
                }
                int ds = Integer.parseInt(dataSize, 16);
                int ts = Integer.parseInt(textSize, 16);
                int programSize = ds + ts;
                System.out.println("program size: " + programSize);
                int bs = Integer.parseInt(bssSize, 16);
                if (programSize > 15872) {
                    Main.writeCompileLog("Program size overflow.", String.valueOf(programSize));
                    ErrorNumber = 8;
                    return 2;
                }
                br.close();
            }
            catch (IOException br) {
                // empty catch block
            }
            System.out.println("objdump: " + ret);
            exe = String.valueOf(BuildConst.ArduinoSystemPath) + BuildConst.Objcopy;
            if (osName.indexOf("Windows") >= 0) {
                exe = String.valueOf(exe) + ".exe";
            }
            if (osName.indexOf("Linux") >= 0) {
                exe = "/usr/share/arduino/hardware/tools/avr/bin/avr-objcopy";
            }
            arg = String.valueOf(BuildConst.ObjcopyOption1) + " ";
            arg = String.valueOf(arg) + BuildConst.ArduinoSystemPath + BuildConst.ElfFile + " ";
            arg = String.valueOf(arg) + BuildConst.ArduinoSystemPath + BuildConst.EepFile;
            commands.clear();
            commands.add(exe);
            args = arg.split(" ");
            i = 0;
            while (i < args.length) {
                commands.add(args[i]);
                ++i;
            }
            pb.command(commands);
            p = pb.start();
            ret = p.waitFor();
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                if (br.readLine() != null) {
                    ErrorNumber = 10;
                    return 0;
                }
                br.close();
            }
            catch (IOException br) {
                // empty catch block
            }
            System.out.println("objcopy1: " + ret);
            arg = String.valueOf(BuildConst.ObjcopyOption2) + " ";
            arg = String.valueOf(arg) + BuildConst.ArduinoSystemPath + BuildConst.ElfFile + " ";
            arg = String.valueOf(arg) + BuildConst.ArduinoSystemPath + BuildConst.USER_PROGRAM;
            commands.clear();
            commands.add(exe);
            args = arg.split(" ");
            i = 0;
            while (i < args.length) {
                commands.add(args[i]);
                ++i;
            }
            pb.command(commands);
            p = pb.start();
            ret = p.waitFor();
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                if (br.readLine() != null) {
                    ErrorNumber = 10;
                    return 0;
                }
                br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println("objcopy2: " + ret);
            return 1;
        }
        catch (InterruptedException e) {
            ErrorNumber = 5;
            return 0;
        }
        catch (IOException e) {
            ErrorNumber = 5;
            return 0;
        }
    }

    static void writeCompileLog(String title, String message) {
        Calendar cal = Calendar.getInstance();
        String logFileName = String.valueOf(String.valueOf(cal.get(1))) + "_";
        logFileName = String.valueOf(logFileName) + String.valueOf(cal.get(2) + 1) + "_";
        logFileName = String.valueOf(logFileName) + String.valueOf(cal.get(5)) + "_";
        logFileName = String.valueOf(logFileName) + String.valueOf(cal.get(10)) + "_";
        logFileName = String.valueOf(logFileName) + String.valueOf(cal.get(12)) + "_";
        logFileName = String.valueOf(logFileName) + String.valueOf(cal.get(13));
        String log = "[" + title + "]\r\n";
        log = String.valueOf(log) + "[message]\t" + message + "\r\n";
        File logFile = new File(logFileName);
        try {
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(logFile)));
            pw.println(log);
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean transferUserProgram(String hexfile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 15[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void transferBoardSide(OutputStream stream, String hexFile) {
        boolean isTransferred = Main.transferUserProgram(hexFile);
        if (isTransferred) {
            PortManager port = PortManager.getInstance();
            try {
                String data = String.valueOf(port.getPortName()) + ";\r\n";
                byte[] msg = data.getBytes("ASCII");
                System.out.println(data);
                stream.write(msg, 0, msg.length);
                data = String.valueOf(String.valueOf(msg.length)) + ";\r\n";
                msg = data.getBytes("ASCII");
                stream.write(msg, 0, msg.length);
                data = "FINISH\r\n";
                msg = data.getBytes("ASCII");
                stream.write(msg, 0, msg.length);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Main.sendErrorMessage(stream);
        }
    }

    static void getPortNumber(OutputStream stream) {
        PortManager port = PortManager.getInstance();
        try {
            String data = String.valueOf(port.getPortName()) + ";\r\n";
            byte[] msg = data.getBytes("ASCII");
            stream.write(msg, 0, msg.length);
            data = String.valueOf(String.valueOf(msg.length)) + ";\r\n";
            msg = data.getBytes("ASCII");
            stream.write(msg, 0, msg.length);
            data = "FINISH\r\n";
            msg = data.getBytes("ASCII");
            stream.write(msg, 0, msg.length);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

