/*
 * Decompiled with CFR 0.152.
 */
package boardmanager;

import gnu.io.CommPortIdentifier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class PortManager {
    private final boolean DEBUG = false;
    public static final int WIN = 0;
    public static final int MAC = 1;
    public static final int LINUX = 2;
    private static PortManager instance = new PortManager();
    private String lastFoundPort;
    private int OSCode = -1;

    private PortManager() {
        String osName = System.getProperty("os.name");
        if (osName.indexOf("Windows") >= 0) {
            this.OSCode = 0;
        } else if (osName.indexOf("Linux") >= 0) {
            this.OSCode = 2;
        } else if (osName.indexOf("Mac") >= 0) {
            this.OSCode = 1;
        }
    }

    public static PortManager getInstance() {
        return instance;
    }

    public String getPortName() {
        String port = "";
        switch (this.OSCode) {
            case 0: {
                port = this.getWinPort();
                break;
            }
            case 1: {
                port = "/dev/" + this.getMacPort();
                break;
            }
            case 2: {
                port = "/dev/" + this.getLinuxPort();
            }
        }
        return port;
    }

    public String getPortArg() {
        String port = "";
        switch (this.OSCode) {
            case 0: {
                port = "\\\\.\\" + this.getWinPort();
                break;
            }
            case 1: {
                port = "/dev/" + this.getMacPort();
                break;
            }
            case 2: {
                port = "/dev/" + this.getLinuxPort();
            }
        }
        return port;
    }

    private String getWinPort() {
        String portName;
        ProcessBuilder pb = new ProcessBuilder("PortSearch.exe");
        pb.redirectErrorStream(true);
        try {
            Process p = pb.start();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                portName = br.readLine();
            }
            p.waitFor();
            if (portName == null) {
                portName = "";
            }
        }
        catch (IOException e) {
            portName = "";
        }
        catch (InterruptedException e) {
            portName = "";
        }
        if (portName.contains("Exception")) {
            portName = null;
            if (this.lastFoundPort != null) {
                Enumeration ports = CommPortIdentifier.getPortIdentifiers();
                while (ports.hasMoreElements()) {
                    CommPortIdentifier elm = (CommPortIdentifier)ports.nextElement();
                    if (!elm.getName().equals(this.lastFoundPort)) continue;
                    portName = this.lastFoundPort;
                    break;
                }
                if (portName == null) {
                    portName = this.checkSerialPort();
                }
            } else {
                portName = this.checkSerialPort();
            }
        }
        this.lastFoundPort = portName;
        return portName;
    }

    private String getMacPort() {
        return "cu.usbserial";
    }

    private String getLinuxPort() {
        Process p;
        String portName = null;
        ProcessBuilder pb = new ProcessBuilder("ls", "/dev/serial/by-id/");
        pb.redirectErrorStream(true);
        String arg = null;
        try {
            p = pb.start();
            arg = this.checkCommandResult_ls(p.getInputStream());
            int n = p.waitFor();
        }
        catch (IOException e) {
            portName = "";
        }
        catch (InterruptedException e) {
            portName = "";
        }
        if (arg == null) {
            return "";
        }
        pb = new ProcessBuilder("file", arg);
        try {
            p = pb.start();
            portName = this.checkCommandResult_file(p.getInputStream());
            int e = p.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return portName;
    }

    private String checkCommandResult_ls(InputStream is) throws IOException {
        String arg = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.contains("Prolific")) continue;
                arg = "/dev/serial/by-id/" + line;
            }
        }
        return arg;
    }

    private String checkCommandResult_file(InputStream is) throws IOException {
        String portName = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line;
            block3: while ((line = br.readLine()) != null) {
                Matcher m = Pattern.compile("ttyUSB[0-9][0-9]*").matcher(line);
                while (true) {
                    if (!m.find()) continue block3;
                    portName = m.group();
                }
                break;
            }
        }
        return portName;
    }

    private String printInputStream(InputStream is) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line;
            String lastLine = "";
            while ((line = br.readLine()) != null) {
                if (!line.contains("pl2303") || !line.contains("attached") || !line.contains("tty")) continue;
                lastLine = line;
            }
            String[] token = lastLine.split(" ");
            int i = 0;
            while (i < token.length) {
                if (token[i].contains("tty")) {
                    String string = token[i];
                    return string;
                }
                ++i;
            }
        }
        return "";
    }

    String checkSerialPort() {
        Enumeration ports = CommPortIdentifier.getPortIdentifiers();
        ArrayList<String> strPort = new ArrayList<String>();
        while (ports.hasMoreElements()) {
            CommPortIdentifier elm = (CommPortIdentifier)ports.nextElement();
            if (!elm.getName().contains("COM")) continue;
            strPort.add(elm.getName());
        }
        if (strPort.size() > 0) {
            JComboBox<Object> jcb = new JComboBox<Object>();
            jcb.setModel(new DefaultComboBoxModel<Object>(strPort.toArray()));
            JOptionPane jop = new JOptionPane(jcb, -1);
            JDialog jd = jop.createDialog("\u30dd\u30fc\u30c8\u306e\u9078\u629e");
            jd.setAlwaysOnTop(true);
            jd.setVisible(true);
            String s = (String)jcb.getSelectedItem();
            jd.dispose();
            if (s != null && s.length() > 0) {
                return s;
            }
        } else {
            JOptionPane.showMessageDialog(null, "\u6709\u52b9\u306a\u30dd\u30fc\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002", "", 2);
        }
        return "";
    }
}

